/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector;

import com.rapidminer.connection.ConnectionHandlerRegistry;
import com.rapidminer.connection.gui.ConnectionGUIProvider;
import com.rapidminer.connection.gui.ConnectionGUIRegistry;
import com.rapidminer.connection.util.GenericHandler;
import com.rapidminer.extension.yassos_connector.connection.YassosAccountHandler;
import com.rapidminer.extension.yassos_connector.gui.YassosAccountGUIProvider;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.TempFileTools;
import java.nio.file.Path;
import java.util.UUID;

public final class PluginInityassosConnector {
    public static final String EXTENSION_ID = "yassos_connector";
    private static final String CACHE_FOLDER_NAME_TEMPLATE = "yassos-cache-%s";
    private static final UUID CACHE_FOLDER_UUID = UUID.randomUUID();
    private static YassosAccountGUIProvider guiProvider;

    private PluginInityassosConnector() {
    }

    public static void initPlugin() {
        ConnectionHandlerRegistry.getInstance().registerHandler((GenericHandler)YassosAccountHandler.INSTANCE);
        Path yassosCachePath = PluginInityassosConnector.getYassosCachePath();
        TempFileTools.registerShutdowncleanup((Path)yassosCachePath);
        LogService.getRoot().info(() -> String.format("%s registered shutdown cleanup for temporary directory '%s'", EXTENSION_ID, yassosCachePath));
    }

    public static Path getYassosCachePath() {
        return Path.of(System.getProperty("java.io.tmpdir"), String.format(CACHE_FOLDER_NAME_TEMPLATE, CACHE_FOLDER_UUID));
    }

    public static void initGui(MainFrame mainframe) {
        guiProvider = new YassosAccountGUIProvider();
        ConnectionGUIRegistry.INSTANCE.registerGUIProvider((ConnectionGUIProvider)guiProvider, "yassos_connector:yassos");
    }

    public static void initFinalChecks() {
    }

    public static void initPluginManager() {
    }

    public static void tearDownGUI() {
        if (guiProvider != null) {
            ConnectionGUIRegistry.INSTANCE.unregisterGUIProvider((ConnectionGUIProvider)guiProvider, "yassos_connector:yassos");
        }
    }

    public static void tearDown() {
        ConnectionHandlerRegistry.getInstance().unregisterHandler((GenericHandler)YassosAccountHandler.INSTANCE);
    }
}

