/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.connection;

import com.altair.yassos.client.YassosAccountAuthProvider;
import com.altair.yassos.client.YassosAccountTokenAuthProvider;
import com.altair.yassos.client.YassosHttpClient;
import com.altair.yassos.client.response.InfoResponse;
import com.rapidminer.connection.ConnectionHandler;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.ConnectionInformationBuilder;
import com.rapidminer.connection.configuration.ConfigurationParameter;
import com.rapidminer.connection.configuration.ConnectionConfiguration;
import com.rapidminer.connection.configuration.ConnectionConfigurationBuilder;
import com.rapidminer.connection.util.ParameterUtility;
import com.rapidminer.connection.util.TestExecutionContext;
import com.rapidminer.connection.util.TestResult;
import com.rapidminer.connection.util.ValidationResult;
import com.rapidminer.connection.valueprovider.handler.ValueProviderHandlerRegistry;
import com.rapidminer.extension.yassos_connector.connection.YassosConnectorClient;
import com.rapidminer.extension.yassos_connector.error.YassosConnectorException;
import com.rapidminer.extension.yassos_connector.util.AssertUtility;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.LogService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public enum YassosAccountHandler implements ConnectionHandler
{
    INSTANCE;

    public static final String CONNECTION_TYPE = "yassos";
    public static final String FULL_TYPE = "yassos_connector:yassos";
    public static final String GROUP_BASIC = "basic";
    public static final String PARAMETER_URL = "url";
    public static final String PARAMETER_CONNECT_TIMEOUT = "connect_timeout";
    public static final String PARAMETER_READ_TIMEOUT = "read_timeout";
    public static final String PARAMETER_WRITE_TIMEOUT = "write_timeout";
    public static final String PARAMETER_ACCOUNT_AUTH_METHOD = "auth_method";
    public static final String PARAMETER_ACCOUNT_AUTH_METHOD_VALUE_TOKEN = "token";
    public static final String PARAMETER_ACCOUNT_AUTH_TOKEN = "auth_token";
    public static final String PARAMETER_ACCOUNT_NAME = "account_name";
    private static final String OPERATOR_CANNOT_BE_NULL = "'operator' cannot be null";
    private static final String CONNECTION_CANNOT_BE_NULL = "'connection' cannot be null";

    public String getType() {
        return FULL_TYPE;
    }

    public ConnectionInformation createNewConnectionInformation(String name) {
        ConnectionConfigurationBuilder configBuilder = new ConnectionConfigurationBuilder(name, FULL_TYPE);
        ArrayList<ConfigurationParameter> parameters = new ArrayList<ConfigurationParameter>();
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_URL).build());
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_ACCOUNT_AUTH_METHOD).withValue(PARAMETER_ACCOUNT_AUTH_METHOD_VALUE_TOKEN).build());
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_ACCOUNT_AUTH_TOKEN, (boolean)true).build());
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_ACCOUNT_NAME).build());
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_CONNECT_TIMEOUT).withValue(String.valueOf(0)).build());
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_READ_TIMEOUT).withValue(String.valueOf(0)).build());
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_WRITE_TIMEOUT).withValue(String.valueOf(0)).build());
        configBuilder.withKeys(GROUP_BASIC, parameters);
        return new ConnectionInformationBuilder(configBuilder.build()).build();
    }

    public ValidationResult validate(ConnectionInformation connection) {
        if (connection == null) {
            return ValidationResult.nullable();
        }
        ConnectionConfiguration configuration = connection.getConfiguration();
        if (configuration == null) {
            return ValidationResult.nullable();
        }
        LinkedHashMap errors = new LinkedHashMap();
        BiConsumer<String, String> errorCollector = errors::put;
        ParameterUtility.validateParameterValue((String)GROUP_BASIC, (String)PARAMETER_URL, (ConnectionConfiguration)configuration, errorCollector);
        ParameterUtility.validateParameterValue((String)GROUP_BASIC, (String)PARAMETER_ACCOUNT_NAME, (ConnectionConfiguration)configuration, errorCollector);
        ParameterUtility.validateParameterValue((String)GROUP_BASIC, (String)PARAMETER_ACCOUNT_AUTH_METHOD, (ConnectionConfiguration)configuration, errorCollector);
        ParameterUtility.validateParameterValue((String)GROUP_BASIC, (String)PARAMETER_CONNECT_TIMEOUT, (ConnectionConfiguration)configuration, errorCollector);
        ParameterUtility.validateParameterValue((String)GROUP_BASIC, (String)PARAMETER_READ_TIMEOUT, (ConnectionConfiguration)configuration, errorCollector);
        ParameterUtility.validateParameterValue((String)GROUP_BASIC, (String)PARAMETER_WRITE_TIMEOUT, (ConnectionConfiguration)configuration, errorCollector);
        return errors.isEmpty() ? ValidationResult.success((String)"validation.success") : ValidationResult.failure((String)"validation.failed", errors, (Object[])new Object[0]);
    }

    public TestResult test(TestExecutionContext<ConnectionInformation> testContext) {
        ConnectionInformation connection = (ConnectionInformation)testContext.getSubject();
        Map values2 = ValueProviderHandlerRegistry.getInstance().injectValues(connection, null, false);
        String url = (String)values2.get("basic.url");
        if (StringUtils.isBlank((CharSequence)url)) {
            return TestResult.failure((String)"test.connection_failed", (Object[])new Object[]{"URL cannot be empty"});
        }
        ConfigurationParameter urlParameter = connection.getConfiguration().getParameter("basic.url");
        if (StringUtils.endsWith((CharSequence)urlParameter.getValue(), (CharSequence)"/")) {
            return TestResult.failure((String)"test.connection_failed", (Object[])new Object[]{"URL cannot end with /"});
        }
        if (!StringUtils.startsWith((CharSequence)urlParameter.getValue(), (CharSequence)"http") && !StringUtils.startsWith((CharSequence)urlParameter.getValue(), (CharSequence)"https")) {
            return TestResult.failure((String)"test.connection_failed", (Object[])new Object[]{"URL must start with valid protocol 'http' or 'https'"});
        }
        try (YassosHttpClient client = new YassosHttpClient(url);){
            InfoResponse response = client.getInfo();
            LogService.getRoot().fine(() -> String.format("Connected to yassos '%s'. Remote time zone is '%s'.", response.getData().getVersion(), response.getData().getTimeZone()));
        }
        catch (Exception e) {
            String msg = String.format("Couldn't connect to yassos. Reason: %s", e.getMessage());
            LogService.getRoot().severe(() -> msg);
            return TestResult.failure((String)"test.connection_failed", (Object[])new Object[]{msg});
        }
        return TestResult.success((String)"test.success");
    }

    public void initialize() {
    }

    public boolean isInitialized() {
        return true;
    }

    public static YassosConnectorClient getClient(ConnectionInformation connection, Operator operator) throws YassosConnectorException {
        AssertUtility.notNull(connection, CONNECTION_CANNOT_BE_NULL);
        AssertUtility.notNull(operator, OPERATOR_CANNOT_BE_NULL);
        Map values2 = ValueProviderHandlerRegistry.getInstance().injectValues(connection, operator, false);
        String url = (String)values2.get("basic.url");
        String connectTimeout = (String)values2.get("basic.connect_timeout");
        String readTimeout = (String)values2.get("basic.read_timeout");
        String writeTimeout = (String)values2.get("basic.write_timeout");
        return new YassosConnectorClient(url, Integer.parseInt(connectTimeout), Integer.parseInt(readTimeout), Integer.parseInt(writeTimeout));
    }

    public static YassosAccountAuthProvider getAuthProvider(ConnectionInformation connection, Operator operator) throws YassosConnectorException {
        AssertUtility.notNull(connection, CONNECTION_CANNOT_BE_NULL);
        AssertUtility.notNull(operator, OPERATOR_CANNOT_BE_NULL);
        Map values2 = ValueProviderHandlerRegistry.getInstance().injectValues(connection, operator, false);
        String authMethod = (String)values2.get("basic.auth_method");
        if (!PARAMETER_ACCOUNT_AUTH_METHOD_VALUE_TOKEN.equals(authMethod)) {
            throw new YassosConnectorException(String.format("'%s' is not a valid authentication method", authMethod));
        }
        String authToken = (String)values2.get("basic.auth_token");
        return new YassosAccountTokenAuthProvider(authToken);
    }

    public static String getAccountName(ConnectionInformation connection, Operator operator) throws YassosConnectorException {
        AssertUtility.notNull(connection, CONNECTION_CANNOT_BE_NULL);
        AssertUtility.notNull(operator, OPERATOR_CANNOT_BE_NULL);
        Map values2 = ValueProviderHandlerRegistry.getInstance().injectValues(connection, operator, false);
        return (String)values2.get("basic.account_name");
    }
}

