/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.connection;

import com.altair.yassos.client.YassosAccountAuthProvider;
import com.altair.yassos.client.YassosHttpClient;
import com.altair.yassos.client.error.ClientException;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.extension.yassos_connector.PluginInityassosConnector;
import com.rapidminer.extension.yassos_connector.connection.YassosAccountHandler;
import com.rapidminer.extension.yassos_connector.error.YassosConnectorException;
import com.rapidminer.extension.yassos_connector.error.YassosConnectorRestException;
import com.rapidminer.extension.yassos_connector.util.AssertUtility;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.nio.file.BinaryEntryFileObject;
import com.rapidminer.operator.nio.file.SimpleFileObject;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryLocationBuilder;
import com.rapidminer.repository.RepositoryLocationType;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.versioned.BasicEntry;
import com.rapidminer.repository.versioned.FilesystemRepositoryAdapter;
import com.rapidminer.tools.FileUtils;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.TempFileTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public class YassosConnectorClient
extends YassosHttpClient {
    private static final String CONNECTION_CANNOT_BE_NULL = "'connection' cannot be null";
    private static final String OPERATOR_CANNOT_BE_NULL = "'operator' cannot be null";
    private static final String NAME_CANNOT_BE_BLANK = "'name' cannot be blank";
    private static final String CONTAINER_NAME_CANNOT_BE_BLANK = "'containerName' cannot be blank";
    private static final String HTTP_META_DATA_CANNOT_BE_NULL = "'httpMetaData' cannot be null";
    private static final String OBJECT_METADATA_RM_CLASS = "Rm-Class";
    private static final String OBJECT_METADATA_RM_FILE_EXTENSION = "Rm-File-Extension";
    private static final String OBJECT_METADATA_RM_ANNOTATION_PREFIX = "Rm-File-Annotation-";
    private static final String ETAG = "etag";
    private String encryptionContext = "default-local-context";

    public YassosConnectorClient(String url) {
        super(url);
    }

    public YassosConnectorClient(String url, int connectTimeout, int readTimeout, int writeTimeout) {
        super(url, connectTimeout, readTimeout, writeTimeout);
    }

    public IOObject retrieveIOO(ConnectionInformation connection, Operator operator, String name, String containerName, String version, boolean useCache, boolean fileSafeName) throws YassosConnectorException {
        AssertUtility.notNull(connection, CONNECTION_CANNOT_BE_NULL);
        AssertUtility.notNull(connection, OPERATOR_CANNOT_BE_NULL);
        AssertUtility.hasText(name, NAME_CANNOT_BE_BLANK);
        AssertUtility.hasText(containerName, CONTAINER_NAME_CANNOT_BE_BLANK);
        File file = this.retrieveFile(connection, operator, name, containerName, version, useCache, fileSafeName);
        if (!file.exists()) {
            return null;
        }
        File dir = file.getParentFile();
        if (dir == null) {
            return null;
        }
        try {
            DataEntry dataEntry;
            FilesystemRepositoryAdapter fra = new FilesystemRepositoryAdapter(UUID.randomUUID().toString(), dir.getAbsolutePath(), false, true, this.encryptionContext);
            List dataEntries = fra.getDataEntries();
            if (dataEntries.isEmpty()) {
                return null;
            }
            if (!useCache) {
                dataEntry = (DataEntry)dataEntries.get(0);
            } else {
                dataEntry = fra.locateData(FileUtils.removeSuffix((String)file.getName()), DataEntry.class, true);
                if (dataEntry == null) {
                    LogService.getRoot().fine(() -> String.format("'%s' didn't result in a valid DataEntry, searching with file suffix", name));
                    dataEntry = fra.locateData(file.getName(), BinaryEntry.class, true);
                }
            }
            if (dataEntry instanceof IOObjectEntry) {
                LogService.getRoot().fine(() -> String.format("'%s' is an IOObjectEntry", name));
                return ((IOObjectEntry)dataEntry).retrieveData(null);
            }
            if (dataEntry instanceof BinaryEntry) {
                LogService.getRoot().fine(() -> String.format("'%s' is a BinaryEntry", name));
                if (!useCache) {
                    LogService.getRoot().fine(() -> String.format("'%s' is not cached, looking up in repository directly", name));
                    return new BinaryEntryFileObject(dataEntry.getLocation());
                }
                Path absPath = fra.getRealPath((BasicEntry)dataEntry);
                LogService.getRoot().fine(() -> String.format("'%s' is cached and located at '%s' on disk", name, absPath.toAbsolutePath()));
                return new SimpleFileObject(absPath.toFile());
            }
            LogService.getRoot().severe(() -> String.format("'%s' cannot be mapped to any known DataEntry", name));
            return null;
        }
        catch (FileNotFoundException e) {
            throw new YassosConnectorException(String.format("Cannot create filesystem repository adapter for '%s'. Reason: %s", name, e.getMessage()), e);
        }
        catch (RepositoryException e) {
            throw new YassosConnectorException(String.format("Cannot convert to IOO for '%s'. Reason: %S", name, e.getMessage()), e);
        }
    }

    public MetaData retrieveMetadata(ConnectionInformation connection, Operator operator, String containerName, String name, String version) throws YassosConnectorException {
        AssertUtility.notNull(connection, CONNECTION_CANNOT_BE_NULL);
        AssertUtility.notNull(operator, OPERATOR_CANNOT_BE_NULL);
        AssertUtility.hasText(containerName, CONTAINER_NAME_CANNOT_BE_BLANK);
        AssertUtility.hasText(name, NAME_CANNOT_BE_BLANK);
        try {
            Map<String, String> httpMetaData = this.getHttpMetaData(connection, operator, containerName, name, version);
            MetaData metaData = new MetaData();
            String fullObjectMetaDataHeaderForRmClass = String.format("%s%s", "X-Object-Meta-", OBJECT_METADATA_RM_CLASS).toLowerCase(Locale.ENGLISH);
            String fullObjectMetaDataHeaderForRmAnnotation = String.format("%s%s", "X-Object-Meta-", OBJECT_METADATA_RM_ANNOTATION_PREFIX).toLowerCase(Locale.ENGLISH);
            if (httpMetaData.containsKey(fullObjectMetaDataHeaderForRmClass)) {
                String clazz = httpMetaData.get(fullObjectMetaDataHeaderForRmClass);
                Class<?> ioObjectClazz = Class.forName(clazz);
                LogService.getRoot().fine(String.format("Found the following IOObject clazz meta data from HTTP call for '%s': %s", name, clazz));
                metaData = new MetaData(ioObjectClazz);
            }
            Annotations annotations = new Annotations();
            for (Map.Entry<String, String> e : httpMetaData.entrySet()) {
                if (!StringUtils.startsWithIgnoreCase((CharSequence)e.getKey(), (CharSequence)fullObjectMetaDataHeaderForRmAnnotation)) continue;
                String key = StringUtils.removeStartIgnoreCase((String)e.getKey(), (String)fullObjectMetaDataHeaderForRmAnnotation);
                LogService.getRoot().fine(String.format("Found the following annotation meta data from HTTP call for '%s': (%s, %s)", name, key, e.getValue()));
                annotations.put(key, e.getValue());
            }
            metaData.setAnnotations(annotations);
            return metaData;
        }
        catch (ClassNotFoundException e) {
            LogService.getRoot().severe(String.format("Failed to retrieve IO class for meta data for '%s': %s", name, e.getMessage()));
            return new MetaData();
        }
    }

    public Map<String, List<String>> storeIOO(ConnectionInformation connection, Operator operator, String name, String containerName, Long deleteAfter, Long deleteAt, Map<String, String> additionalMetadata, IOObject ioo, boolean etagValidation) throws YassosConnectorException {
        AssertUtility.notNull(connection, CONNECTION_CANNOT_BE_NULL);
        AssertUtility.notNull(operator, OPERATOR_CANNOT_BE_NULL);
        AssertUtility.hasText(name, NAME_CANNOT_BE_BLANK);
        AssertUtility.hasText(containerName, CONTAINER_NAME_CANNOT_BE_BLANK);
        AssertUtility.notNull(additionalMetadata, "'additionalMetadata' cannot be null");
        AssertUtility.notNull(ioo, "'ioo' cannot be null");
        try {
            Path tmpDir = Files.createTempDirectory("yassos-tmp-dir-", new FileAttribute[0]);
            TempFileTools.registerCleanup((Path)tmpDir);
            LogService.getRoot().fine(String.format("Storing '%s' to volatile '%s'", name, tmpDir.toAbsolutePath()));
            FilesystemRepositoryAdapter fra = new FilesystemRepositoryAdapter(UUID.randomUUID().toString(), tmpDir.toFile().getAbsolutePath(), true, true, this.encryptionContext);
            RepositoryLocation entryLocation = new RepositoryLocationBuilder().withLocationType(RepositoryLocationType.DATA_ENTRY).buildFromParentLocation(fra.getLocation(), "entry");
            RepositoryManager.getInstance(null).store(ioo, entryLocation, operator);
            List dataEntries = fra.getDataEntries();
            if (dataEntries.isEmpty()) {
                return Collections.emptyMap();
            }
            DataEntry dataEntry = (DataEntry)dataEntries.get(0);
            if (!(dataEntry instanceof BasicEntry)) {
                return Collections.emptyMap();
            }
            Path realPath = fra.getRealPath((BasicEntry)dataEntry);
            HashMap<String, String> metaData = new HashMap<String, String>(0);
            boolean anyInvalidHeaderKeys = additionalMetadata.entrySet().stream().anyMatch(e -> !this.isValidHeaderKey((String)e.getKey()));
            if (anyInvalidHeaderKeys) {
                throw new YassosConnectorException("Found additional metadata keys with illegal characters, only alpha numeric characters and dashes are allowed");
            }
            Map<String, String> filteredAdditionalMetadata = additionalMetadata.entrySet().stream().filter(e -> this.isValidHeaderKey((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            metaData.putAll(filteredAdditionalMetadata);
            metaData.put(OBJECT_METADATA_RM_CLASS, ioo.getClass().getName());
            ioo.getAnnotations().getDefinedAnnotationNames().forEach(annotation -> {
                String annotationValue = ioo.getAnnotations().getAnnotation(annotation);
                if (StringUtils.isAlphanumeric((CharSequence)annotation) && StringUtils.isNotBlank((CharSequence)annotationValue)) {
                    metaData.put(String.format("%s%s", OBJECT_METADATA_RM_ANNOTATION_PREFIX, annotation), annotationValue);
                } else {
                    LogService.getRoot().warning(String.format("Skipped sending annotation '%s' for file '%s', because its value is blank or its key contains illegal characters, only alpha numeric characters and dashes are allowed", annotation, name));
                }
            });
            Optional<String> fileExtension = this.getExtensionByStringHandling(realPath.getFileName().normalize().toAbsolutePath().toString());
            fileExtension.ifPresent(s -> metaData.put(OBJECT_METADATA_RM_FILE_EXTENSION, (String)s));
            metaData.forEach((k, v) -> LogService.getRoot().fine(String.format("Sending meta data (%s,%s)", k, v)));
            String accountName = YassosAccountHandler.getAccountName(connection, operator);
            YassosAccountAuthProvider authProvider = YassosAccountHandler.getAuthProvider(connection, operator);
            return this.objectUpload(accountName, containerName, authProvider, realPath.toFile(), name, etagValidation, null, deleteAfter, deleteAt, metaData);
        }
        catch (ClientException e2) {
            throw new YassosConnectorRestException(String.format("Failed to upload IOO. Reason: %s", e2.getMessage()), e2);
        }
        catch (MalformedRepositoryLocationException | RepositoryException | IOException e3) {
            throw new YassosConnectorException(String.format("Failed to process IOO. Reason: %s", e3.getMessage()), e3);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private File retrieveFile(ConnectionInformation connection, Operator operator, String name, String containerName, String version, boolean useCache, boolean fileSafeName) throws YassosConnectorException {
        AssertUtility.notNull(connection, CONNECTION_CANNOT_BE_NULL);
        AssertUtility.notNull(operator, OPERATOR_CANNOT_BE_NULL);
        AssertUtility.hasText(name, NAME_CANNOT_BE_BLANK);
        Map<String, String> httpMetaData = null;
        if (useCache) {
            LogService.getRoot().fine(() -> String.format("File caching is enabled, comparing local and remote via HTTP call for '%s'", name));
            httpMetaData = this.getHttpMetaData(connection, operator, containerName, name, version);
            Path cachePath = this.getCachePathForObject(httpMetaData);
            if (cachePath != null && Files.exists(cachePath, new LinkOption[0]) && !org.apache.commons.io.FileUtils.isDirectory((File)cachePath.toFile(), (LinkOption[])new LinkOption[0])) {
                LogService.getRoot().fine(String.format("File caching is enabled and found the following file on disk for '%s': %s", name, cachePath.normalize().toAbsolutePath()));
                return cachePath.toFile();
            }
            LogService.getRoot().fine(() -> String.format("File caching is enabled, did not find any match or remote file has been updated for '%s'", name));
        }
        try {
            String safeName;
            Path tmpDir = Files.createTempDirectory("yassos-tmp-dir-", new FileAttribute[0]);
            LogService.getRoot().fine(String.format("Storing '%s' to volatile '%s'", name, tmpDir.toAbsolutePath()));
            TempFileTools.registerCleanup((Path)tmpDir);
            if (fileSafeName) {
                LogService.getRoot().fine(() -> String.format("File safe name is enabled for '%s'", name));
                safeName = RegExUtils.replaceAll((String)name, (String)"[\\\\/:\"*?<>|]", (String)"_");
            } else {
                safeName = name;
            }
            LogService.getRoot().fine(() -> String.format("Download name for '%s' is '%s'...", name, safeName));
            Path downloadedFile = tmpDir.resolve(safeName);
            String accountName = YassosAccountHandler.getAccountName(connection, operator);
            YassosAccountAuthProvider authProvider = YassosAccountHandler.getAuthProvider(connection, operator);
            Integer objectVersion = null;
            if (StringUtils.isNotBlank((CharSequence)version)) {
                LogService.getRoot().fine(() -> String.format("Retrieving specific version '%s' for '%s'", version, name));
                objectVersion = Integer.parseInt(version);
            }
            LogService.getRoot().fine(() -> String.format("Downloading '%s' to '%s'...", name, downloadedFile.toAbsolutePath()));
            Map<String, List<String>> headers = this.objectDownload(accountName, containerName, authProvider, downloadedFile.toFile(), name, objectVersion);
            LogService.getRoot().fine(() -> String.format("Finished downloading '%s' to '%s'", name, downloadedFile.toAbsolutePath()));
            Path finalFile = downloadedFile;
            List<String> fileExtension = headers.get(String.format("X-Object-Meta-%s", OBJECT_METADATA_RM_FILE_EXTENSION));
            if (fileExtension != null && !fileExtension.isEmpty()) {
                LogService.getRoot().fine(() -> String.format("Got a file extension from HTTP call for '%s': %s, adding suffix...", name, fileExtension));
                finalFile = tmpDir.resolve(safeName + "." + String.join((CharSequence)"", fileExtension));
                LogService.getRoot().fine(String.format("Final file for '%s' is '%s'", name, finalFile));
                LogService.getRoot().fine(String.format("Moving '%s' from '%s' to '%s'", name, downloadedFile.toAbsolutePath(), finalFile.toAbsolutePath()));
                org.apache.commons.io.FileUtils.moveFile((File)downloadedFile.toFile(), (File)finalFile.toFile());
                LogService.getRoot().fine(String.format("Finished moving '%s' from '%s' to '%s'", name, downloadedFile.toAbsolutePath(), finalFile.toAbsolutePath()));
            }
            if (useCache) {
                Path cachePath = this.getCachePathForObject(httpMetaData);
                LogService.getRoot().fine(String.format("File caching is enabled, trying to store '%s' from '%s' to '%s'", name, finalFile, cachePath));
                if (cachePath != null) {
                    org.apache.commons.io.FileUtils.moveFile((File)finalFile.toFile(), (File)cachePath.toFile());
                    LogService.getRoot().fine(String.format("File caching is enabled, stored '%s' in '%s'", name, cachePath));
                    return cachePath.toFile();
                }
            }
            return finalFile.toFile();
        }
        catch (ClientException e) {
            throw new YassosConnectorRestException(String.format("Failed to download IOO. Reason: %s", e.getMessage()), e);
        }
        catch (IOException e) {
            throw new YassosConnectorException(String.format("I/O error during IOO retrieval or processing. Reason: %s", e.getMessage()), e);
        }
    }

    private Optional<String> getExtensionByStringHandling(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }

    private Map<String, String> getHttpMetaData(ConnectionInformation connection, Operator operator, String containerName, String name, String version) throws YassosConnectorException {
        AssertUtility.notNull(connection, CONNECTION_CANNOT_BE_NULL);
        AssertUtility.notNull(operator, OPERATOR_CANNOT_BE_NULL);
        AssertUtility.hasText(containerName, CONTAINER_NAME_CANNOT_BE_BLANK);
        AssertUtility.hasText(name, NAME_CANNOT_BE_BLANK);
        String accountName = YassosAccountHandler.getAccountName(connection, operator);
        YassosAccountAuthProvider authProvider = YassosAccountHandler.getAuthProvider(connection, operator);
        Integer objectVersion = null;
        if (StringUtils.isNotBlank((CharSequence)version)) {
            objectVersion = Integer.parseInt(version);
        }
        try {
            Map<String, List<String>> retrievedMetaData = this.objectMetaDataRetrieval(accountName, containerName, authProvider, name, objectVersion);
            Map<String, String> transformedRetrievedMetaData = retrievedMetaData.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> ((List)e.getValue()).stream().reduce("", String::concat)));
            transformedRetrievedMetaData.forEach((k, v) -> LogService.getRoot().fine(String.format("Found the following meta data from HTTP call for '%s': (%s, %s)", name, k, v)));
            return transformedRetrievedMetaData;
        }
        catch (ClientException e2) {
            throw new YassosConnectorException(String.format("Failed to retrieve meta data for '%s': %s", name, e2.getMessage()), e2);
        }
    }

    private Path getCachePathForObject(Map<String, String> httpMetaData) throws YassosConnectorException {
        AssertUtility.notNull(httpMetaData, HTTP_META_DATA_CANNOT_BE_NULL);
        if (httpMetaData.containsKey(ETAG)) {
            StringBuilder builder = new StringBuilder();
            builder.append(httpMetaData.get(ETAG));
            String rmFileExtension = String.format("X-Object-Meta-%s", OBJECT_METADATA_RM_FILE_EXTENSION).toLowerCase(Locale.ENGLISH);
            if (httpMetaData.containsKey(rmFileExtension)) {
                builder.append(".");
                builder.append(httpMetaData.get(rmFileExtension));
            }
            return PluginInityassosConnector.getYassosCachePath().resolve(builder.toString());
        }
        return null;
    }
}

