/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.operator;

import com.altair.yassos.client.YassosAccountAuthProvider;
import com.altair.yassos.client.error.ClientException;
import com.altair.yassos.client.response.ContainerDetail;
import com.altair.yassos.client.response.ContainersResponse;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.extension.yassos_connector.connection.YassosAccountHandler;
import com.rapidminer.extension.yassos_connector.connection.YassosConnectorClient;
import com.rapidminer.extension.yassos_connector.error.YassosConnectorException;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.SuggestionProvider;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ContainerSuggestionProvider
implements SuggestionProvider<String> {
    public List<String> getSuggestions(Operator op, ProgressListener pl) {
        if (op == null || op.getProcess() == null || !(op instanceof ConnectionSelectionProvider)) {
            return Collections.emptyList();
        }
        ConnectionInformationSelector informationSelector = ((ConnectionSelectionProvider)op).getConnectionSelector();
        if (informationSelector == null) {
            return Collections.emptyList();
        }
        try {
            return this.getContainerNames(op, informationSelector.getConnection());
        }
        catch (UserError e) {
            LogService.getRoot().finer(() -> String.format("Could not retrieve container suggestions. Reason: %s", e.getMessage()));
            return Collections.emptyList();
        }
    }

    public ResourceAction getAction() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getContainerNames(Operator op, ConnectionInformation connection) {
        if (op == null) return Collections.emptyList();
        if (connection == null) {
            return Collections.emptyList();
        }
        try (YassosConnectorClient client = YassosAccountHandler.getClient(connection, op);){
            String accountName = YassosAccountHandler.getAccountName(connection, op);
            YassosAccountAuthProvider authProvider = YassosAccountHandler.getAuthProvider(connection, op);
            ContainersResponse response = client.containerList(accountName, authProvider);
            if (response == null) return Collections.emptyList();
            if (response.getData() == null) return Collections.emptyList();
            List<String> list = response.getData().stream().map(ContainerDetail::getName).distinct().sorted().collect(Collectors.toList());
            return list;
        }
        catch (ClientException | YassosConnectorException e) {
            LogService.getRoot().finer(() -> ContainerSuggestionProvider.lambda$getContainerNames$1((Exception)e));
            return Collections.emptyList();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ String lambda$getContainerNames$1(Exception e) {
        return String.format("Could not retrieve container suggestions. Reason: %s", e.getMessage());
    }
}

