/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.operator;

import com.altair.yassos.client.YassosAccountAuthProvider;
import com.altair.yassos.client.constant.ContainerPermissionPrivilege;
import com.altair.yassos.client.error.ClientException;
import com.altair.yassos.client.response.ContainerPermissionResponse;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.table.Table;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.extension.yassos_connector.connection.YassosAccountHandler;
import com.rapidminer.extension.yassos_connector.connection.YassosConnectorClient;
import com.rapidminer.extension.yassos_connector.error.YassosConnectorException;
import com.rapidminer.extension.yassos_connector.operator.ContainerSuggestionProvider;
import com.rapidminer.extension.yassos_connector.util.CreateContainerPermissionToTableConverter;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.metadata.table.TableMetaDataBuilder;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDateTimeString;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CreateContainerPermission
extends Operator
implements ConnectionSelectionProvider {
    public static final String PARAMETER_CONTAINER_NAME = "container_name";
    public static final String PARAMETER_PRIVILEGE = "privilege";
    public static final String PARAMETER_LABEL = "label";
    public static final String PARAMETER_EXPIRATION = "expiration";
    public static final String[] PRIVILEGES = new String[]{ContainerPermissionPrivilege.READ.toString(), ContainerPermissionPrivilege.WRITE.toString()};
    public OutputPort exaOut = (OutputPort)this.getOutputPorts().createPort("exa");
    private ConnectionInformationSelector selector = new ConnectionInformationSelector((Operator)this, "yassos_connector:yassos");

    public CreateContainerPermission(OperatorDescription description) {
        super(description);
        this.selector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
        TableMetaData metaData = new TableMetaDataBuilder(MDInteger.newUnknown()).addNominal("id", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addNominal("token", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addNominal(PARAMETER_PRIVILEGE, null, SetRelation.SUPERSET, MDInteger.newUnknown()).addNominal(PARAMETER_LABEL, null, SetRelation.SUPERSET, MDInteger.newUnknown()).addDateTime(PARAMETER_EXPIRATION, null, SetRelation.SUPERSET, MDInteger.newUnknown()).addDateTime("createdAt", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addDateTime("updatedAt", null, SetRelation.SUPERSET, MDInteger.newUnknown()).build();
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.exaOut, (MetaData)metaData));
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.selector.getConnection();
        Table result = CreateContainerPermissionToTableConverter.getEmptyTable();
        try (YassosConnectorClient client = YassosAccountHandler.getClient(connection, this);){
            String accountName = YassosAccountHandler.getAccountName(connection, this);
            YassosAccountAuthProvider authProvider = YassosAccountHandler.getAuthProvider(connection, this);
            String containerName = this.getParameterAsString(PARAMETER_CONTAINER_NAME);
            String privilege = this.getParameterAsString(PARAMETER_PRIVILEGE);
            String labelParam = this.getParameterAsString(PARAMETER_LABEL);
            String label = null;
            if (StringUtils.isNotBlank((CharSequence)labelParam)) {
                label = labelParam;
            }
            String expirationParam = this.getParameterAsString(PARAMETER_EXPIRATION);
            Long expiration = null;
            if (StringUtils.isNotBlank((CharSequence)expirationParam)) {
                try {
                    TemporalAccessor ta = DateTimeFormatter.ISO_DATE_TIME.parse(expirationParam);
                    Instant i = Instant.from(ta);
                    expiration = i.toEpochMilli() / 1000L;
                }
                catch (DateTimeParseException e) {
                    throw new OperatorException(String.format("Failed to parse delete at. Reason: %s", e.getMessage()), (Throwable)e);
                }
            }
            ContainerPermissionResponse response = client.containerPermissionCreation(accountName, containerName, ContainerPermissionPrivilege.valueOf(privilege), label, expiration, authProvider);
            result = CreateContainerPermissionToTableConverter.convert(response);
        }
        catch (ClientException | YassosConnectorException e) {
            throw new OperatorException(String.format("Failed to create container permission. Reason: %s", ((Throwable)e).getMessage()), (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selector.passDataThrough();
        this.exaOut.deliver((IOObject)new IOTable(result));
    }

    public List<ParameterType> getParameterTypes() {
        List parameterTypes = super.getParameterTypes();
        parameterTypes.add(0, new ParameterTypeSuggestion(PARAMETER_CONTAINER_NAME, "The container name the object resides in", (SuggestionProvider)new ContainerSuggestionProvider(), "", false));
        parameterTypes.add(1, new ParameterTypeCategory(PARAMETER_PRIVILEGE, "The privilege", PRIVILEGES, 0));
        parameterTypes.add(2, new ParameterTypeString(PARAMETER_LABEL, "The optional label", true, true));
        parameterTypes.add(3, new ParameterTypeDateTimeString(PARAMETER_EXPIRATION, "Optional date and time when this permission will be invalid, e.g., 2011-12-03T10:15:30+01:00[Europe/Paris])", true, true, DateTimeFormatter.ISO_DATE_TIME));
        return parameterTypes;
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.selector;
    }

    public void setConnectionSelector(ConnectionInformationSelector connectionInformationSelector) {
    }
}

