/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.operator;

import com.altair.yassos.client.YassosAccountAuthProvider;
import com.altair.yassos.client.error.ClientException;
import com.altair.yassos.client.response.ContainerPermissionsResponse;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.table.Table;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.extension.yassos_connector.connection.YassosAccountHandler;
import com.rapidminer.extension.yassos_connector.connection.YassosConnectorClient;
import com.rapidminer.extension.yassos_connector.error.YassosConnectorException;
import com.rapidminer.extension.yassos_connector.operator.ContainerSuggestionProvider;
import com.rapidminer.extension.yassos_connector.util.ListContainerPermissionsToTableConverter;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.metadata.table.TableMetaDataBuilder;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import java.io.IOException;
import java.util.List;

public class ListContainerPermissions
extends Operator
implements ConnectionSelectionProvider {
    public static final String PARAMETER_CONTAINER_NAME = "container_name";
    public OutputPort exaOut = (OutputPort)this.getOutputPorts().createPort("exa");
    private ConnectionInformationSelector selector = new ConnectionInformationSelector((Operator)this, "yassos_connector:yassos");

    public ListContainerPermissions(OperatorDescription description) {
        super(description);
        this.selector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
        TableMetaData metaData = new TableMetaDataBuilder(MDInteger.newUnknown()).addNominal("id", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addNominal("token", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addNominal("privilege", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addNominal("label", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addDateTime("expiration", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addDateTime("createdAt", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addDateTime("updatedAt", null, SetRelation.SUPERSET, MDInteger.newUnknown()).build();
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.exaOut, (MetaData)metaData));
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.selector.getConnection();
        Table result = ListContainerPermissionsToTableConverter.getEmptyTable();
        try (YassosConnectorClient client = YassosAccountHandler.getClient(connection, this);){
            String accountName = YassosAccountHandler.getAccountName(connection, this);
            YassosAccountAuthProvider authProvider = YassosAccountHandler.getAuthProvider(connection, this);
            String containerName = this.getParameterAsString(PARAMETER_CONTAINER_NAME);
            ContainerPermissionsResponse response = client.containerPermissions(accountName, containerName, authProvider);
            result = ListContainerPermissionsToTableConverter.convert(response);
        }
        catch (ClientException | YassosConnectorException e) {
            throw new OperatorException(String.format("Failed to list container permissions. Reason: %s", ((Throwable)e).getMessage()), (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selector.passDataThrough();
        this.exaOut.deliver((IOObject)new IOTable(result));
    }

    public List<ParameterType> getParameterTypes() {
        List parameterTypes = super.getParameterTypes();
        parameterTypes.add(0, new ParameterTypeSuggestion(PARAMETER_CONTAINER_NAME, "The container name", (SuggestionProvider)new ContainerSuggestionProvider(), "", false));
        return parameterTypes;
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.selector;
    }

    public void setConnectionSelector(ConnectionInformationSelector connectionInformationSelector) {
    }
}

