/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.operator;

import com.altair.yassos.client.YassosAccountAuthProvider;
import com.altair.yassos.client.constant.ContainerContentsOrderBy;
import com.altair.yassos.client.constant.ContainerContentsOrderDirection;
import com.altair.yassos.client.error.ClientException;
import com.altair.yassos.client.response.ContainerContentsResponse;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.table.Table;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.extension.yassos_connector.connection.YassosAccountHandler;
import com.rapidminer.extension.yassos_connector.connection.YassosConnectorClient;
import com.rapidminer.extension.yassos_connector.error.YassosConnectorException;
import com.rapidminer.extension.yassos_connector.operator.ContainerSuggestionProvider;
import com.rapidminer.extension.yassos_connector.util.ListContentsToTableConverter;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.metadata.table.TableMetaDataBuilder;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import java.io.IOException;
import java.util.List;

public class ListContents
extends Operator
implements ConnectionSelectionProvider {
    public static final String PARAMETER_CONTAINER_NAME = "container_name";
    public static final String PARAMETER_PREFIX = "prefix";
    public static final String PARAMETER_LATEST = "latest";
    public static final String PARAMETER_ORDER_BY = "order_by";
    public static final String PARAMETER_ORDER_DIRECTION = "order_direction";
    public static final String PARAMETER_ORDER_BY_VALUE_NAME = "name";
    public static final String PARAMETER_ORDER_BY_VALUE_VERSION = "version";
    public static final String PARAMETER_ORDER_BY_VALUE_CREATED_AT = "created_at";
    public static final String PARAMETER_ORDER_BY_VALUE_UPDATED_AT = "updated_at";
    public static final String PARAMETER_ORDER_BY_VALUE_DELETE_AT = "delete_at";
    public static final String PARAMETER_ORDER_DIRECTION_VALUE_ASC = "asc";
    public static final String PARAMETER_ORDER_DIRECTION_VALUE_DESC = "desc";
    public OutputPort exaOut = (OutputPort)this.getOutputPorts().createPort("exa");
    private ConnectionInformationSelector selector = new ConnectionInformationSelector((Operator)this, "yassos_connector:yassos");

    public ListContents(OperatorDescription description) {
        super(description);
        this.selector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
        TableMetaData metaData = new TableMetaDataBuilder(MDInteger.newUnknown()).addNominal(PARAMETER_ORDER_BY_VALUE_NAME, null, SetRelation.SUPERSET, MDInteger.newUnknown()).addInteger(PARAMETER_ORDER_BY_VALUE_VERSION, null, SetRelation.SUPERSET, MDInteger.newUnknown()).addDateTime("createdAt", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addDateTime("updatedAt", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addDateTime("deleteAt", null, SetRelation.SUPERSET, MDInteger.newUnknown()).build();
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.exaOut, (MetaData)metaData));
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.selector.getConnection();
        Table result = ListContentsToTableConverter.getEmptyTable();
        try (YassosConnectorClient client = YassosAccountHandler.getClient(connection, this);){
            ContainerContentsOrderDirection orderDirection;
            ContainerContentsOrderBy orderBy;
            String accountName = YassosAccountHandler.getAccountName(connection, this);
            YassosAccountAuthProvider authProvider = YassosAccountHandler.getAuthProvider(connection, this);
            String containerName = this.getParameterAsString(PARAMETER_CONTAINER_NAME);
            String prefix = this.getParameterAsString(PARAMETER_PREFIX);
            switch (this.getParameterAsString(PARAMETER_ORDER_BY)) {
                case "version": {
                    orderBy = ContainerContentsOrderBy.VERSION;
                    break;
                }
                case "created_at": {
                    orderBy = ContainerContentsOrderBy.CREATED_AT;
                    break;
                }
                case "updated_at": {
                    orderBy = ContainerContentsOrderBy.UPDATED_AT;
                    break;
                }
                case "delete_at": {
                    orderBy = ContainerContentsOrderBy.DELETE_AT;
                    break;
                }
                default: {
                    orderBy = ContainerContentsOrderBy.NAME;
                }
            }
            switch (this.getParameterAsString(PARAMETER_ORDER_DIRECTION)) {
                case "desc": {
                    orderDirection = ContainerContentsOrderDirection.DESC;
                    break;
                }
                default: {
                    orderDirection = ContainerContentsOrderDirection.ASC;
                }
            }
            ContainerContentsResponse response = client.containerContents(accountName, containerName, prefix, this.getParameterAsBoolean(PARAMETER_LATEST), orderBy, orderDirection, authProvider);
            result = ListContentsToTableConverter.convert(response);
        }
        catch (ClientException | YassosConnectorException e) {
            throw new OperatorException(String.format("Failed to list contents. Reason: %s", ((Throwable)e).getMessage()), (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selector.passDataThrough();
        this.exaOut.deliver((IOObject)new IOTable(result));
    }

    public List<ParameterType> getParameterTypes() {
        List parameterTypes = super.getParameterTypes();
        parameterTypes.add(0, new ParameterTypeSuggestion(PARAMETER_CONTAINER_NAME, "The container name the object resides in", (SuggestionProvider)new ContainerSuggestionProvider(), "", false));
        parameterTypes.add(1, new ParameterTypeString(PARAMETER_PREFIX, "Optional prefix which should start with a leading slash, e.g., /myfolder/sub/files-", true, false));
        parameterTypes.add(2, new ParameterTypeBoolean(PARAMETER_LATEST, "The version of the object to retrieve; if left blank, the latest available is retrieved", true, false));
        ParameterTypeCategory orderBy = new ParameterTypeCategory(PARAMETER_ORDER_BY, "order by", new String[]{PARAMETER_ORDER_BY_VALUE_NAME, PARAMETER_ORDER_BY_VALUE_VERSION, PARAMETER_ORDER_BY_VALUE_CREATED_AT, PARAMETER_ORDER_BY_VALUE_UPDATED_AT, PARAMETER_ORDER_BY_VALUE_DELETE_AT}, 0);
        orderBy.setOptional(false);
        orderBy.setExpert(false);
        parameterTypes.add(orderBy);
        ParameterTypeCategory orderDirection = new ParameterTypeCategory(PARAMETER_ORDER_DIRECTION, "order direction", new String[]{PARAMETER_ORDER_DIRECTION_VALUE_ASC, PARAMETER_ORDER_DIRECTION_VALUE_DESC}, 0);
        orderDirection.setOptional(false);
        orderDirection.setExpert(false);
        parameterTypes.add(orderDirection);
        return parameterTypes;
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.selector;
    }

    public void setConnectionSelector(ConnectionInformationSelector connectionInformationSelector) {
    }
}

