/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.operator;

import com.altair.yassos.client.YassosAccountAuthProvider;
import com.altair.yassos.client.error.ClientException;
import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.table.Table;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.extension.yassos_connector.connection.YassosAccountHandler;
import com.rapidminer.extension.yassos_connector.connection.YassosConnectorClient;
import com.rapidminer.extension.yassos_connector.error.YassosConnectorException;
import com.rapidminer.extension.yassos_connector.operator.ContainerSuggestionProvider;
import com.rapidminer.extension.yassos_connector.util.ObjectMetadataToTableConverter;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.table.TableMetaData;
import com.rapidminer.operator.ports.metadata.table.TableMetaDataBuilder;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ReadMetadataObject
extends Operator
implements ConnectionSelectionProvider {
    public static final String PARAMETER_OBJECT_NAME = "name";
    public static final String PARAMETER_CONTAINER_NAME = "container_name";
    public static final String PARAMETER_OBJECT_VERSION = "version";
    public OutputPort exaOut = (OutputPort)this.getOutputPorts().createPort("exa");
    private ConnectionInformationSelector selector = new ConnectionInformationSelector((Operator)this, "yassos_connector:yassos");

    public ReadMetadataObject(OperatorDescription description) {
        super(description);
        this.selector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
        TableMetaData metaData = new TableMetaDataBuilder(MDInteger.newUnknown()).addNominal("key", null, SetRelation.SUPERSET, MDInteger.newUnknown()).addNominal("value", null, SetRelation.SUPERSET, MDInteger.newUnknown()).build();
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewMDRule(this.exaOut, (MetaData)metaData));
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.selector.getConnection();
        Table result = ObjectMetadataToTableConverter.getEmptyTable();
        try (YassosConnectorClient client = YassosAccountHandler.getClient(connection, this);){
            String accountName = YassosAccountHandler.getAccountName(connection, this);
            YassosAccountAuthProvider authProvider = YassosAccountHandler.getAuthProvider(connection, this);
            String containerName = this.getParameterAsString(PARAMETER_CONTAINER_NAME);
            String name = this.getParameterAsString(PARAMETER_OBJECT_NAME);
            String version = this.getParameterAsString(PARAMETER_OBJECT_VERSION);
            Integer parsedVersion = null;
            try {
                parsedVersion = Integer.parseInt(version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Map<String, List<String>> response = client.objectMetaDataRetrieval(accountName, containerName, authProvider, name, parsedVersion);
            result = ObjectMetadataToTableConverter.convert(response);
        }
        catch (ClientException | YassosConnectorException e) {
            throw new OperatorException(String.format("Failed to read object metadata. Reason: %s", ((Throwable)e).getMessage()), (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selector.passDataThrough();
        this.exaOut.deliver((IOObject)new IOTable(result));
    }

    public List<ParameterType> getParameterTypes() {
        List parameterTypes = super.getParameterTypes();
        parameterTypes.add(0, new ParameterTypeString(PARAMETER_OBJECT_NAME, "The name of the object to read metadata", false));
        parameterTypes.add(1, new ParameterTypeSuggestion(PARAMETER_CONTAINER_NAME, "The container name the object resides in", (SuggestionProvider)new ContainerSuggestionProvider(), "", false));
        parameterTypes.add(2, new ParameterTypeString(PARAMETER_OBJECT_VERSION, "The version of the object to read metadata; if left blank, the latest available is read", true));
        return parameterTypes;
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.selector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

