/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.extension.yassos_connector.connection.YassosAccountHandler;
import com.rapidminer.extension.yassos_connector.connection.YassosConnectorClient;
import com.rapidminer.extension.yassos_connector.error.YassosConnectorException;
import com.rapidminer.extension.yassos_connector.operator.ContainerSuggestionProvider;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import java.io.IOException;
import java.util.List;

public class ReadObject
extends AbstractReader<IOObject>
implements ConnectionSelectionProvider {
    public static final String PARAMETER_OBJECT_NAME = "name";
    public static final String PARAMETER_CONTAINER_NAME = "container_name";
    public static final String PARAMETER_OBJECT_VERSION = "version";
    public static final String PARAMETER_FILE_CACHING = "file_caching";
    public static final String PARAMETER_FILE_SAFE_NAME = "file_safe_name";
    private ConnectionInformationSelector selector = new ConnectionInformationSelector((Operator)this, "yassos_connector:yassos");

    public ReadObject(OperatorDescription description) {
        super(description, IOObject.class);
        this.selector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
    }

    public MetaData getGeneratedMetaData() throws OperatorException {
        MetaData metaData;
        block9: {
            ConnectionInformation connection = this.selector.getConnection();
            YassosConnectorClient client = YassosAccountHandler.getClient(connection, (Operator)this);
            try {
                metaData = client.retrieveMetadata(connection, (Operator)this, this.getParameter(PARAMETER_CONTAINER_NAME), this.getParameter(PARAMETER_OBJECT_NAME), this.getParameterAsString(PARAMETER_OBJECT_VERSION));
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (YassosConnectorException e) {
                    throw new OperatorException(String.format("Failed to read object's meta data. Reason: %s", e.getMessage()), (Throwable)((Object)e));
                }
                catch (IOException iOException) {
                    return super.getGeneratedMetaData();
                }
            }
            client.close();
        }
        return metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOObject read() throws OperatorException {
        block13: {
            ConnectionInformation connection = this.selector.getConnection();
            try {
                IOObject iOObject;
                block12: {
                    YassosConnectorClient client = YassosAccountHandler.getClient(connection, (Operator)this);
                    try {
                        String name = this.getParameterAsString(PARAMETER_OBJECT_NAME);
                        String containerName = this.getParameterAsString(PARAMETER_CONTAINER_NAME);
                        String version = this.getParameterAsString(PARAMETER_OBJECT_VERSION);
                        boolean fileCaching = this.getParameterAsBoolean(PARAMETER_FILE_CACHING);
                        boolean fileSafeName = this.getParameterAsBoolean(PARAMETER_FILE_SAFE_NAME);
                        iOObject = client.retrieveIOO(connection, (Operator)this, name, containerName, version, fileCaching, fileSafeName);
                        if (client == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (client != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (YassosConnectorException e) {
                            throw new OperatorException(String.format("Failed to read object. Reason: %s", e.getMessage()), (Throwable)((Object)e));
                        }
                        catch (IOException iOException) {
                            break block13;
                        }
                    }
                    client.close();
                }
                return iOObject;
            }
            finally {
                this.selector.passDataThrough();
            }
        }
        return null;
    }

    public List<ParameterType> getParameterTypes() {
        List parameterTypes = super.getParameterTypes();
        parameterTypes.add(0, new ParameterTypeString(PARAMETER_OBJECT_NAME, "The name of the object to retrieve", false));
        parameterTypes.add(1, new ParameterTypeSuggestion(PARAMETER_CONTAINER_NAME, "The container name the object resides in", (SuggestionProvider)new ContainerSuggestionProvider(), "", false));
        parameterTypes.add(2, new ParameterTypeString(PARAMETER_OBJECT_VERSION, "The version of the object to retrieve; if left blank, the latest available is retrieved", true));
        parameterTypes.add(3, new ParameterTypeBoolean(PARAMETER_FILE_CACHING, "To enable optional file caching. When enabled, before an object is downloaded, a simple cache is checked via sha256 checksum if that object already exists locally. This cache can grow large and is cleaned up only on engine shutdown. It resides in Java's default location named 'yassos-cache'. If disabled, objects are always downloaded. It's recommended to turn this on.", true));
        parameterTypes.add(4, new ParameterTypeBoolean(PARAMETER_FILE_SAFE_NAME, "Uses safe names to temporarily store objects locally before transposing as IOObject to the process. Disable with care.", true, true));
        return parameterTypes;
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.selector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

