/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.extension.yassos_connector.connection.YassosAccountHandler;
import com.rapidminer.extension.yassos_connector.connection.YassosConnectorClient;
import com.rapidminer.extension.yassos_connector.error.YassosConnectorException;
import com.rapidminer.extension.yassos_connector.operator.ContainerSuggestionProvider;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDateTimeString;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeSuggestion;
import com.rapidminer.parameter.SuggestionProvider;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class WriteObject
extends AbstractWriter<IOObject>
implements ConnectionSelectionProvider {
    public static final String ANNOTATION_OBJECT_NAME = "yassos.objectName";
    public static final String ANNOTATION_OBJECT_SIZE = "yassos.objectSize";
    public static final String ANNOTATION_OBJECT_ETAG = "yassos.objectEtag";
    public static final String PARAMETER_OBJECT_NAME = "name";
    public static final String PARAMETER_CONTAINER_NAME = "container_name";
    public static final String PARAMETER_DELETE_AFTER = "delete_after";
    public static final String PARAMETER_DELETE_AT = "delete_at";
    public static final String PARAMETER_METADATA = "metadata";
    public static final String PARAMETER_METADATA_ITEM_KEY = "metadata_item_key";
    public static final String PARAMETER_METADATA_ITEM_value = "metadata_item_value";
    public static final String PARAMETER_ETAG_VALIDATION = "etag_validation";
    public static final String PARAMETER_PREFER_ANNOTATION = "prefer_annotation";
    private ConnectionInformationSelector selector = new ConnectionInformationSelector((Operator)this, "yassos_connector:yassos");

    public WriteObject(OperatorDescription description) {
        super(description, IOObject.class);
        this.selector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
    }

    public IOObject write(IOObject ioobject) throws OperatorException {
        ConnectionInformation connection = this.selector.getConnection();
        long deleteAfterParam = this.getParameterAsLong(PARAMETER_DELETE_AFTER);
        Long deleteAfter = null;
        if (deleteAfterParam >= 1L) {
            deleteAfter = deleteAfterParam;
        }
        String deleteAtParam = this.getParameterAsString(PARAMETER_DELETE_AT);
        Long deleteAt = null;
        if (StringUtils.isNotBlank((CharSequence)deleteAtParam)) {
            try {
                TemporalAccessor ta = DateTimeFormatter.ISO_DATE_TIME.parse(deleteAtParam);
                Instant i = Instant.from(ta);
                deleteAt = i.toEpochMilli() / 1000L;
            }
            catch (DateTimeParseException e2) {
                throw new OperatorException(String.format("Failed to parse delete at. Reason: %s", e2.getMessage()), (Throwable)e2);
            }
        }
        HashMap<String, String> additionalMetadata = new HashMap<String, String>(0);
        for (String[] attributeValuePair : this.getParameterList(PARAMETER_METADATA)) {
            String key = attributeValuePair[0];
            String value = attributeValuePair[1];
            additionalMetadata.put(key, value);
        }
        try (YassosConnectorClient client = YassosAccountHandler.getClient(connection, (Operator)this);){
            String objectEtag;
            String objectSize;
            String annotatedFileName;
            boolean preferNameFromAnnotation = this.getParameterAsBoolean(PARAMETER_PREFER_ANNOTATION);
            String fileName = this.getParameterAsString(PARAMETER_OBJECT_NAME);
            if (preferNameFromAnnotation && ioobject.getAnnotations().containsKey((Object)"Filename") && StringUtils.isNotBlank((CharSequence)(annotatedFileName = ioobject.getAnnotations().get((Object)"Filename")))) {
                fileName = annotatedFileName;
            }
            if (StringUtils.isBlank((CharSequence)fileName)) {
                throw new UserError((Operator)this, "write_object.annotation_missing", new Object[]{"Filename"});
            }
            Map<String, List<String>> responseHeaders = client.storeIOO(connection, (Operator)this, fileName, this.getParameterAsString(PARAMETER_CONTAINER_NAME), deleteAfter, deleteAt, additionalMetadata, ioobject, this.getParameterAsBoolean(PARAMETER_ETAG_VALIDATION));
            Map<String, String> condensedResponseHeaders = responseHeaders.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> ((List)e.getValue()).stream().reduce("", String::concat)));
            String objectName = condensedResponseHeaders.get("X-Object-File-Name".toLowerCase());
            if (StringUtils.isNotBlank((CharSequence)objectName)) {
                objectName = StringUtils.prependIfMissing((String)objectName, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                ioobject.getAnnotations().put(ANNOTATION_OBJECT_NAME, objectName);
            }
            if (StringUtils.isNotBlank((CharSequence)(objectSize = condensedResponseHeaders.get("X-Object-File-Bytes".toLowerCase())))) {
                ioobject.getAnnotations().put(ANNOTATION_OBJECT_SIZE, objectSize);
            }
            if (StringUtils.isNotBlank((CharSequence)(objectEtag = condensedResponseHeaders.get("Etag".toLowerCase())))) {
                ioobject.getAnnotations().put(ANNOTATION_OBJECT_ETAG, objectEtag);
            }
        }
        catch (YassosConnectorException e3) {
            throw new OperatorException(String.format("Failed to write object. Reason: %s", e3.getMessage()), (Throwable)((Object)e3));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selector.passDataThrough();
        return ioobject;
    }

    public List<ParameterType> getParameterTypes() {
        List parameterTypes = super.getParameterTypes();
        parameterTypes.add(0, new ParameterTypeString(PARAMETER_OBJECT_NAME, "The name of the object to write. Required if 'Prefer Annotation' is disabled. Also required if 'Prefer Annotation' is enabled, but the input has not been annotated. Can be the full path or omit the leading / as it will always be added automatically. If no name is provided by either mechanism, an error is raised.", true));
        parameterTypes.add(1, new ParameterTypeSuggestion(PARAMETER_CONTAINER_NAME, "The container name the object resides in", (SuggestionProvider)new ContainerSuggestionProvider(), "", false));
        parameterTypes.add(2, new ParameterTypeLong(PARAMETER_DELETE_AFTER, "Optional time in seconds when this object is automatically deleted", Long.MIN_VALUE, Long.MAX_VALUE, -1L, true));
        parameterTypes.add(3, new ParameterTypeDateTimeString(PARAMETER_DELETE_AT, "Optional date and time when this object is automatically deleted, e.g., 2011-12-03T10:15:30+01:00[Europe/Paris]); delete after takes precedence over this", true, true, DateTimeFormatter.ISO_DATE_TIME));
        parameterTypes.add(4, new ParameterTypeList(PARAMETER_METADATA, "metadata item", (ParameterType)new ParameterTypeString(PARAMETER_METADATA_ITEM_KEY, "metadata item key", true, false), (ParameterType)new ParameterTypeString(PARAMETER_METADATA_ITEM_value, "metadata item value", true, false), true));
        parameterTypes.add(5, new ParameterTypeBoolean(PARAMETER_ETAG_VALIDATION, "if set to true, object's checksum is calculated upfront", true, true));
        parameterTypes.add(6, new ParameterTypeBoolean(PARAMETER_PREFER_ANNOTATION, "if set to true, the object's name will be taken from the Filename annotation if available (be careful, not all Operators provide such an annotation). Defaults to false. You can also annotate manually with the with Annotate operator", false, true));
        return parameterTypes;
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.selector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

