/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.util;

import com.rapidminer.extension.yassos_connector.error.YassosConnectorIllegalArgumentException;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class AssertUtility {
    private AssertUtility() {
        throw new IllegalStateException("Utility class");
    }

    public static void hasText(String value, String message) throws YassosConnectorIllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new YassosConnectorIllegalArgumentException(message);
        }
    }

    public static void notNull(Object value, String message) throws YassosConnectorIllegalArgumentException {
        if (value == null) {
            throw new YassosConnectorIllegalArgumentException(message);
        }
    }

    public static void atLeastOneNotNull(Collection values2, String message) throws YassosConnectorIllegalArgumentException {
        for (Object value : values2) {
            if (value == null) continue;
            return;
        }
        throw new YassosConnectorIllegalArgumentException(message);
    }

    public static void allHaveText(Set<String> values2, String message) throws YassosConnectorIllegalArgumentException {
        if (values2 != null) {
            for (String group : values2) {
                AssertUtility.hasText(group, message);
            }
        }
    }

    public static void verifyCondition(boolean condition, String message) throws YassosConnectorIllegalArgumentException {
        if (!condition) {
            throw new YassosConnectorIllegalArgumentException(message);
        }
    }

    public static void verifyLengthLE(String property, String propertyName, int maxLength) throws YassosConnectorIllegalArgumentException {
        AssertUtility.hasText(property, String.format("'%s' cannot be blank", propertyName));
        AssertUtility.hasText(propertyName, "'propertyName' cannot be blank");
        AssertUtility.verifyCondition(property.length() <= maxLength, String.format("'%s' cannot be longer than %s characters", propertyName, maxLength));
    }
}

