/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.util;

import com.altair.yassos.client.response.ContainerPermissionDetail;
import com.altair.yassos.client.response.ContainerPermissionResponse;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.table.MixedRowWriter;
import com.rapidminer.belt.table.Table;
import com.rapidminer.belt.table.Writers;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class CreateContainerPermissionToTableConverter {
    public static List<String> getLabels = Arrays.asList("id", "token", "privilege", "label", "expiration", "createdAt", "updatedAt");
    public static List<Column.TypeId> getColumnTypes = Arrays.asList(Column.TypeId.NOMINAL, Column.TypeId.NOMINAL, Column.TypeId.NOMINAL, Column.TypeId.NOMINAL, Column.TypeId.DATE_TIME, Column.TypeId.DATE_TIME, Column.TypeId.DATE_TIME);

    private CreateContainerPermissionToTableConverter() {
        throw new IllegalStateException("Utility class");
    }

    public static Table getEmptyTable() {
        MixedRowWriter writer = Writers.mixedRowWriter(getLabels, getColumnTypes, (boolean)false);
        return writer.create();
    }

    public static Table convert(ContainerPermissionResponse response) {
        MixedRowWriter writer = Writers.mixedRowWriter(getLabels, getColumnTypes, (boolean)false);
        CreateContainerPermissionToTableConverter.appendDetail(writer, response.getData());
        return writer.create();
    }

    public static void appendDetail(MixedRowWriter writer, ContainerPermissionDetail detail) {
        writer.move();
        writer.set(0, (Object)detail.getId().toString());
        writer.set(1, (Object)detail.getToken());
        writer.set(2, (Object)detail.getPrivilege().toString().toLowerCase(Locale.ENGLISH));
        writer.set(3, (Object)detail.getLabel());
        if (detail.getExpiration() != null) {
            writer.set(4, (Object)Instant.ofEpochSecond(detail.getExpiration()));
        } else {
            writer.set(4, null);
        }
        writer.set(5, (Object)Instant.parse(detail.getCreatedAt()));
        writer.set(6, (Object)Instant.parse(detail.getUpdatedAt()));
    }
}

