/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.util;

import com.altair.yassos.client.response.ContainerDetail;
import com.altair.yassos.client.response.ContainersResponse;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.table.MixedRowWriter;
import com.rapidminer.belt.table.Table;
import com.rapidminer.belt.table.Writers;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;

public final class ListContainersToTableConverter {
    public static List<String> getLabels = Arrays.asList("name", "versioning", "createdAt", "updatedAt");
    public static List<Column.TypeId> getColumnTypes = Arrays.asList(Column.TypeId.NOMINAL, Column.TypeId.NOMINAL, Column.TypeId.DATE_TIME, Column.TypeId.DATE_TIME);

    private ListContainersToTableConverter() {
        throw new IllegalStateException("Utility class");
    }

    public static Table getEmptyTable() {
        MixedRowWriter writer = Writers.mixedRowWriter(getLabels, getColumnTypes, (boolean)false);
        return writer.create();
    }

    public static Table convert(ContainersResponse response) {
        MixedRowWriter writer = Writers.mixedRowWriter(getLabels, getColumnTypes, (boolean)false);
        for (ContainerDetail c : response.getData()) {
            ListContainersToTableConverter.appendDetail(writer, c);
        }
        return writer.create();
    }

    public static void appendDetail(MixedRowWriter writer, ContainerDetail detail) {
        writer.move();
        writer.set(0, (Object)detail.getName());
        writer.set(1, (Object)String.valueOf(detail.isVersioning()));
        writer.set(2, (Object)Instant.parse(detail.getCreatedAt()));
        writer.set(3, (Object)Instant.parse(detail.getUpdatedAt()));
    }
}

