/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.yassos_connector.util;

import com.altair.yassos.client.response.ContainerContentsResponse;
import com.altair.yassos.client.response.ObjectDetail;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.table.MixedRowWriter;
import com.rapidminer.belt.table.Table;
import com.rapidminer.belt.table.Writers;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;

public final class ListContentsToTableConverter {
    public static List<String> getLabels = Arrays.asList("name", "version", "createdAt", "updatedAt", "deleteAt");
    public static List<Column.TypeId> getColumnTypes = Arrays.asList(Column.TypeId.NOMINAL, Column.TypeId.INTEGER_53_BIT, Column.TypeId.DATE_TIME, Column.TypeId.DATE_TIME, Column.TypeId.DATE_TIME);

    private ListContentsToTableConverter() {
        throw new IllegalStateException("Utility class");
    }

    public static Table getEmptyTable() {
        MixedRowWriter writer = Writers.mixedRowWriter(getLabels, getColumnTypes, (boolean)false);
        return writer.create();
    }

    public static Table convert(ContainerContentsResponse response) {
        MixedRowWriter writer = Writers.mixedRowWriter(getLabels, getColumnTypes, (boolean)false);
        for (ObjectDetail c : response.getData()) {
            ListContentsToTableConverter.appendDetail(writer, c);
        }
        return writer.create();
    }

    public static void appendDetail(MixedRowWriter writer, ObjectDetail detail) {
        writer.move();
        writer.set(0, (Object)detail.getName());
        writer.set(1, (double)detail.getVersion());
        writer.set(2, (Object)Instant.parse(detail.getCreatedAt()));
        writer.set(3, (Object)Instant.parse(detail.getUpdatedAt()));
        if (detail.getDeleteAt() != null) {
            writer.set(4, (Object)Instant.parse(detail.getDeleteAt()));
        } else {
            writer.set(4, null);
        }
    }
}

